﻿using System;
using System.Collections.Generic;

namespace Eliza
{
    /// <summary>
    /// A speech pattern.
    /// </summary>
    class Pattern
    {
        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="Pattern"/> class.
        /// </summary>
        /// <param name="phraseToMatch">The phrase to match.</param>
        public Pattern
            (string phraseToMatch)
        {
            this.PhraseToMatch = phraseToMatch;
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the phrase to match.
        /// </summary>
        public string PhraseToMatch {
            get;
            private set;
        }

        #endregion

        #region Public methods

        /// <summary>
        /// Checks if the pattern matches the user's input.
        /// </summary>
        /// <param name="input">The user's input.</param>
        /// <returns><see langword="true"/> if the pattern matches the user's input, otherwise <see langword="false"/>.</returns>
        public bool MatchesInput
            (string input)
        {
            // Check if the pattern's phrase was found
            return input.Contains(this.PhraseToMatch);
        }

        /// <summary>
        /// Generates a human-like response.
        /// </summary>
        /// <returns>The response.</returns>
        public string GenerateResponse()
        {
            // Create the list of possible responses (for the BECAUSE pattern)
            List<string> responses = new List<string>();
            if (this.PhraseToMatch == "BECAUSE") {
                responses.Add("IS THAT THE REAL REASON?");
                responses.Add("DON'T ANY OTHER REASONS COME TO MIND?");
                responses.Add("DOES THAT REASON SEEM TO EXPLAIN ANYTHING ELSE?");
                responses.Add("WHAT OTHER REASONS MIGHT THERE BE?");
            }

            // Pick a random response to return
            Random random = new Random();
            int index = random.Next(responses.Count);

            // Return the response
            return responses[index];
        }

        #endregion
    }
}
